<?php

$result = array();
$xmlData = preg_replace(
    // get rid of the namespaces in the elements like in <d:StatusCode>
    '~(</?)\w+:~',
    '$1',
    // use the callback to remove all attributes like m:type="Edm.Int32"
    // but keep the namespace declaration at the root element
    preg_replace_callback(
        '~ (\w+):([\w\d]+=")~',
        function($match) {
            return ($match[1] == 'xmlns')
                ? $match[0] : ' '.$match[2];
        },
        file_get_contents('crm_result.xml')
    )
);
$xml = simplexml_load_string($xmlData);

if (is_object($xml)) {
    if (isset($xml->entry)) {
        foreach ($xml->entry as $i => $entry) {
            $result[] = array(
                'guid' => mb_substr((string)$entry->id, -38, 36), // guids have a fixed size
                'name' => (string)$entry->title,
                'status' => (string)$entry->content->properties->StatusCode->Value,
                'id' => $entry->content->properties->AccountNumber->__toString(),
                'address' => str_replace('&#xD;', "\n", $entry->content->properties->Address1_Composite),
            );
        }
    }
    var_dump($result);
}
