<?php

$result = array();
$xml = simplexml_load_file('crm_result.xml');
if (is_object($xml)) {
    foreach ($xml->getDocNamespaces() as $k => $v) {
        if ($k == '') $k = 'c'; // hack to fill the empty prefix
        $xml->registerXPathNamespace($k, $v);
    }
    $entries = $xml->xpath('//c:entry');
    if (is_array($entries)) {
        foreach ($entries as $entry) {
            // use the content of the $entry to build a new XML tree
            $node = simplexml_load_string(
                //  get rid of the namespaces in the elements like in <d:StatusCode>
                preg_replace('~(</?)\w+:~', '$1',
                    // and in the attributes like m:type="Edm.Int32"
                    preg_replace('~ \w+:([\w\d]+=")~', ' $1', $entry->asXML())
                )
            );
            $result[] = array(
                'guid' => mb_substr((string)$entry->id, -38, 36),  // guids have a fixed size
                'name' => (string)$entry->title,
                'status' => (string)$node->content->properties->StatusCode->Value,
                'id' => $node->content->properties->AccountNumber->__toString(),
                'address' => str_replace('&#xD;', "\n", $node->content->properties->Address1_Composite),
            );
        }
    }
    var_dump($result);
}
