<?php


class MyParser {

    protected $output;
    protected $inComment;
    protected $level;
    
    public function flush()
    {
        $this->output = '';
        $this->inComment = null;
        $this->level = 0;
    
    }

    protected function handleStartTag(XMLParser $parser, string $name, array $attr) :void
    {
        $this->level++;
        if ($name === 'COMMENT') {
            $this->output .= $attr['AUTHOR'];
            $this->inComment = true;
        }
    }

    protected function handleEndTag(XMLParser $parser, string $name) :void
    {
        $this->level--;
        if ($name === 'COMMENT') {
            $this->inComment = null;
        }
    }

    protected function handleData(XMLParser $parser, string $data) :void
    {
        if ($this->level === 2 && $this->inComment) {
            $this->output .= ': ' . trim($data) . PHP_EOL;
        }
    }
    
    public function parse(string $xmlFile) :string
    {
        $this->flush();
        $stream = fopen($xmlFile, 'r');
        // create new XMLParser instance
        $parser = xml_parser_create();
        // and setup event handlers for the parser.
        xml_set_element_handler($parser, [$this, 'handleStartTag'], [$this, 'handleEndTag']);
        xml_set_character_data_handler($parser, [$this, 'handleData']); 
        // start parsing
        while (($data = fread($stream, 4096))) {
            xml_parse($parser, $data);
        }
        // free resources
        xml_parse($parser, '', true);
        xml_parser_free($parser);
        fclose($stream);
        // return the collected data string
        return $this->output;
    }
}

echo (new MyParser())->parse('chat.xml');
