<?php

$author;

function startTag(XMLParser $parser, string $name, array $attr) {
    global $author;
    if ($name === 'COMMENT') {
        $author = $attr['AUTHOR'];
    }
}

function endTag(XMLParser $parser, string $name) {
    global $author;
    if ($name === 'COMMENT') {
        $author = null;
    }
}

function printComment(XMLParser $parser, string $data) {
    global $author;
    if (!empty($author)) {
        echo $author . ': ' . trim($data) . PHP_EOL;
    }
}

$stream = fopen('chat.xml', 'r');
$parser = xml_parser_create();
xml_set_element_handler($parser, 'startTag', 'endTag');
xml_set_character_data_handler($parser, 'printComment'); 
// set up the handlers here
while (($data = fread($stream, 4096))) {
    xml_parse($parser, $data); // parse the current chunk
}
xml_parse($parser, '', true); // finalize parsing
xml_parser_free($parser);
fclose($stream);
